/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client;

import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.sonarqube.ws.client.BaseResponse;

class HttpResponse
extends BaseResponse {
    private final Response okResponse;

    HttpResponse(Response okResponse) {
        this.okResponse = okResponse;
    }

    @Override
    public int code() {
        return this.okResponse.code();
    }

    @Override
    public String requestUrl() {
        return this.okResponse.request().urlString();
    }

    @Override
    public boolean hasContent() {
        return this.okResponse.code() != 204;
    }

    @Override
    public String contentType() {
        return this.okResponse.header("Content-Type");
    }

    @Override
    public InputStream contentStream() {
        try {
            return this.okResponse.body().byteStream();
        }
        catch (IOException e) {
            throw this.fail(e);
        }
    }

    @Override
    public Reader contentReader() {
        try {
            return this.okResponse.body().charStream();
        }
        catch (IOException e) {
            throw this.fail(e);
        }
    }

    @Override
    public String content() {
        try {
            return this.okResponse.body().string();
        }
        catch (IOException e) {
            throw this.fail(e);
        }
    }

    private RuntimeException fail(Exception e) {
        throw new IllegalStateException("Fail to read response of " + this.requestUrl(), e);
    }
}

